/*
 * Decompiled with CFR 0.152.
 */
package blueduck.outerend.blocks;

import blueduck.outerend.features.TreeGenerationContext;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SaplingBlock;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.event.ForgeEventFactory;

public class EnderSaplingBlock
extends BushBlock
implements IGrowable {
    public static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    private final Consumer<TreeGenerationContext> generator;

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    public EnderSaplingBlock(AbstractBlock.Properties properties, Consumer<TreeGenerationContext> generator) {
        super(properties);
        this.generator = generator;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)SaplingBlock.field_176479_b, (Comparable)Integer.valueOf(0)));
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return null;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_235714_a_(BlockTags.func_199896_a().func_241834_b(new ResourceLocation("outer_end:end_plantable_on")));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SaplingBlock.field_176479_b});
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        this.onPlantGrow(state, (IWorld)worldIn, pos, pos);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (worldIn.func_201696_r(pos.func_177984_a()) >= 9 && random.nextInt(7) == 0) {
            if (!worldIn.isAreaLoaded(pos, 1)) {
                return;
            }
            this.onPlantGrow(state, (IWorld)worldIn, pos, pos);
        }
    }

    public void onPlantGrow(BlockState state, IWorld world, BlockPos pos, BlockPos source) {
        boolean flag = false;
        for (int i = 1; i < 6; ++i) {
            if (world.func_180495_p(pos.func_177981_b(i)) == Blocks.field_150350_a.func_176223_P()) continue;
            flag = true;
        }
        if (flag) {
            return;
        }
        if ((Integer)state.func_177229_b((Property)SaplingBlock.field_176479_b) == 0) {
            world.func_241211_a_(pos, (BlockState)state.func_206870_a((Property)SaplingBlock.field_176479_b, (Comparable)Integer.valueOf(1)), 4, 0);
        } else {
            if (!ForgeEventFactory.saplingGrowTree((IWorld)world, (Random)world.func_201674_k(), (BlockPos)pos)) {
                return;
            }
            this.generator.accept(new TreeGenerationContext<IWorld>(world, pos, world.func_201674_k()));
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }
}

